/*
 * Decompiled with CFR 0.152.
 */
package com.android.order.domain.use_case.read;

import com.android.order.domain.model.AOrderDtlDto;
import com.android.order.domain.use_case.read.FetchAOrderDetails;
import com.android.order.domain.use_case.read.FetchAOrderDtlSize;
import com.android.order.domain.use_case.read.FetchAOrderDtlVariety;
import com.dto.LoginDto;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="session")
public class BuildAOrderDtl {
    private final FetchAOrderDetails fetchAOrderDetails;
    private final FetchAOrderDtlSize fetchAOrderDtlSize;
    private final FetchAOrderDtlVariety fetchAOrderDtlVariety;

    public List<AOrderDtlDto> invoke(LoginDto login, List<String> orderIdList) {
        List dtlList = this.fetchAOrderDetails.invoke(login, orderIdList);
        List sizeList = this.fetchAOrderDtlSize.invoke(login, orderIdList);
        List varietyList = this.fetchAOrderDtlVariety.invoke(login, orderIdList);
        return dtlList.stream().peek(dtl -> {
            dtl.setVarietyList(varietyList.stream().filter(variety -> variety.getInvoiceDtlId().equals(dtl.getServerId())).collect(Collectors.toList()));
            dtl.setSizeList(sizeList.stream().filter(size -> size.getOrderDtlId() == dtl.getServerId()).collect(Collectors.toList()));
        }).collect(Collectors.toList());
    }

    public BuildAOrderDtl(FetchAOrderDetails fetchAOrderDetails, FetchAOrderDtlSize fetchAOrderDtlSize, FetchAOrderDtlVariety fetchAOrderDtlVariety) {
        this.fetchAOrderDetails = fetchAOrderDetails;
        this.fetchAOrderDtlSize = fetchAOrderDtlSize;
        this.fetchAOrderDtlVariety = fetchAOrderDtlVariety;
    }
}

